<?php
/**
 * 2007-2015 Leotheme
 *
 * NOTICE OF LICENSE
 *
 * Leo feature for prestashop 1.7: ajax cart, review, compare, wishlist at product list
 *
 * DISCLAIMER
 *
 *  @author    leotheme <leotheme@gmail.com>
 *  @copyright 2007-2015 Leotheme
 *  @license   http://leotheme.com - prestashop template provider
 */
require_once(_PS_MODULE_DIR_.'leofeature/classes/LeoProductAttribute.php');
require_once(_PS_MODULE_DIR_.'leofeature/classes/LeofeatureProduct.php');

if (!defined('_PS_VERSION_')) {
    # module validation
    exit;
}

class LeofeatureLeoProductAttributeModuleFrontController extends ModuleFrontController
{
    public function displayAjaxGetProductAttribute()
    {
        $id_product = (int)  Tools::getValue('id_product');
        $context = Context::getContext();
        $module = new Leofeature();
        $id_product_attribute = LeoProductAttribute::getProductAttributesID($id_product, Tools::getValue('group'));
        
        $product = new Product ($id_product);
        $product->loadStockData();
        
        $product_array = Tools::jsonDecode(  Tools::jsonEncode($product), true );
        $product_array['quantity'] = Product::getQuantity(
            $id_product, (int) $id_product_attribute, isset($product_array['cache_is_pack']) ? $product_array['cache_is_pack'] : null
        );
        $product_array['allow_oosp'] = Product::isAvailableWhenOutOfStock($product_array['out_of_stock']);


        $add_to_cart_url = null;
        if ($module->shouldEnableAddToCartButton($product_array)) {
            $add_to_cart_url = Context::getContext()->link->getAddToCartURL($id_product, $id_product_attribute);
        }
        
        $attribute_data = new LeofeatureProduct();
        $result = $attribute_data->getTemplateVarProduct2($id_product, $id_product_attribute);
        die(Tools::jsonEncode(array(
            'product_cover' => $result['cover'],
            'price_attribute'   => $module->renderPriceAttribute($result),
            'product_url' => Context::getContext()->link->getProductLink($id_product, null, null, null, $context->language->id, null, $id_product_attribute, false, false, true),
            'id_attr' => $id_product_attribute,
//            'add_to_cart_url' => Context::getContext()->link->getAddToCartURL($id_product, $id_product_attribute),
            'add_to_cart_url' => $add_to_cart_url,
        )));
        
    }
}

